#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Fork Rolling wa firebreath 440Mod01.fsh  by  firebreathz
//https://www.shadertoy.com/view/7ssSzl
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define MAX_STEPS 120
#define MAX_DIST 120.
#define SURF_DIST .01

float GetDistance(vec3 point) {
	
    float texture = sin((iTime + point.x)*.5)*2.7+cos(point.z*2.5+sin(iTime)*5.)*.1+sin(point.x*5.+point.z*10.)*0.03;
    float planeDist = point.y + texture*.5;
    
    float planeDist2 = -point.y + 3. + texture*.5;;
    
    return min(planeDist,planeDist2);
}

vec3 GetNormal(vec3 point) {
  float distance = GetDistance(point);
  vec2 e = vec2(.01,0);
  
  vec3 normal = distance - vec3(
      GetDistance(point-e.xyy),
      GetDistance(point-e.yxy),
      GetDistance(point-e.yyx));
  
  return normalize(normal);
}

vec2 RayMarch(vec3 rayOrgin, vec3 rayDirection) {
	float distance=0.;
    
    int steps = MAX_STEPS; 
    int i = 0;
    
    for(i=0; i<steps; i++) {
    	vec3 point = rayOrgin + rayDirection * distance;
        float surfaceDistance = GetDistance(point);
        distance += surfaceDistance;
        // Stop marching if we go too far or we are close enough of surface
        if(distance>MAX_DIST || surfaceDistance<SURF_DIST) break;
    }
    
    return vec2(distance,i);
}

float GetLight(vec3 point, vec3 normal, vec3 lightPos) {    
  
  vec3 direction = normalize(lightPos-point);
  
  float dif = clamp(dot(normal, direction), 0., 1.);
  
  float d = RayMarch(point+normal*.1, direction).x;
  if ( d < length(lightPos-point)) dif *= .5;
  
  return dif;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // put 0,0 in the center
    vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;
       
    // camera   
    vec3 rayOrgin = vec3(0, 1.5, 0);
    vec3 rayDirection = normalize(vec3(uv.x, uv.y, 1));

    vec2 d = RayMarch(rayOrgin, rayDirection);
    
    vec3 col = vec3(0.);
    
    vec3 lightPos = vec3(1, 1.5, 1);
    
    if (d.x < 120.) {
        vec3 p = rayOrgin + rayDirection * d.x;
        vec3 n = GetNormal(p);
        float light = GetLight(p, n, lightPos);
        // color
        float dist = d.x/50.;
        col = vec3(
            light-dist,
            light-dist/1.5+(d.y*0.004),
            light-dist/2.+(d.y*0.005)
        );
    }
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

